/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
 * File name     : bddefs.h
 * board properties and generic functions
 ***********************************************************************/


#ifndef __BDDEFS_H
#define __BDDEFS_H


#ifndef CLI
#define CLI
#endif


#define B_BOARDPROP_SIZE	 5

CLI typedef enum {
  B_BOARD_RSTMODE,        	/* @rstmode */
  B_BOARD_PERREN,		/* @perren  */
  B_BOARD_SERREN,		/* @serren  */
  B_BOARD_ROMUSAGE,		/* @romusage */
  B_BOARD_HOTSWAPMODE		/* @hsmode      */
} b_boardproptype;

CLI /* DEF_START ~G_BoardHSMode ~~B_BOARD_HOTSWAPMODE */
#define B_BOARD_HOTSWAP_NONE	0x0	/* @hsnone     */
#define B_BOARD_HOTSWAP_BASIC	0x1	/* @hsbasic    */
#define B_BOARD_HOTSWAP_FULL	0x2	/* @hsfull     */
#define B_BOARD_HOTSWAP_HIGH	0x3	/* @hshigh     */
#define B_BOARD_HOTSWAP_STEALTH	0x4	/* @hsstealth  */
CLI /* DEF_END */


#define B_SINFO_SIZE 4

CLI typedef enum {
  B_SINFO_BUSSPEED,		/* @speed */
  B_SINFO_BUSWIDTH,		/* @width */
  B_SINFO_LASTRESET,            /* @lastreset */
  B_SINFO_CPCI_GA               /* @cpciga */
} b_systeminfotype;

/* Definition of status bits for BestStatusRegGet */
/* use '&' to test for single status              */

CLI /* DEF_START ~G_Status */
#define B_STATUS_MASTER_RUN	(1UL <<  0)	/* mrun		*/
#define B_STATUS_TARGET_RUN	(1UL <<  1)	/* trun		*/
#define B_STATUS_OBS_RUN	(1UL <<  2)	/* orun		*/
#define B_STATUS_TRC_RUN	(1UL <<  3)	/* trcrun	*/
#define B_STATUS_PROT_ERR	(1UL <<  4)	/* proterr	*/
#define B_STATUS_DATA_ERR	(1UL <<  5)	/* dataerr	*/
#define B_STATUS_MASTER_ABORT	(1UL <<  7)	/* mabort	*/
#define B_STATUS_INTA		(1UL <<  8)	/* inta		*/
#define B_STATUS_INTB		(1UL <<  9)	/* intb		*/
#define B_STATUS_INTC		(1UL << 10)	/* intc		*/
#define B_STATUS_INTD		(1UL << 11)	/* intd		*/
#define B_STATUS_SELFTRAFFIC	(1UL << 14)	/* selftraffic	*/
#define B_STATUS_PCIRST		(1UL << 16)	/* pcirst	*/
#define B_STATUS_CPUP_BUSERR	(1UL << 31)	/* cpupbuserr	*/
CLI /* DEF_END */

#endif


